
---------------------------------------------------------------------------------------------------
-- Add Modif Log tables for Respondent and Response tables
---------------------------------------------------------------------------------------------------
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id('[ResponseModifLog]') AND OBJECTPROPERTY(id, 'IsUserTable') = 1)
BEGIN  
  CREATE TABLE ResponseModifLog
  (
		Id         int identity NOT NULL,
		Respondent varchar(10) NOT NULL,
		Question   nvarchar(10) NOT NULL,
		Matrix     int NOT NULL,
		Mention    int NOT NULL,
		[Content]  nvarchar(100) NULL,
		OldContent nvarchar(100) NULL,
		OpenEnd    nvarchar(max) NULL,
		OldOpenEnd nvarchar(max) NULL,
		Source     nvarchar(max) NULL,
		Comment    nvarchar(max) NULL,
		modifiedBy int NOT NULL,
		modified   datetime NOT NULL
	)
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id('[RespondentModifLog]') AND OBJECTPROPERTY(id, 'IsUserTable') = 1)
BEGIN
	CREATE TABLE RespondentModifLog
	(
		Id            int identity NOT NULL,
		Respondent    varchar(10) NOT NULL,
		[Action]      nvarchar(15) NOT NULL,
		FieldName     nvarchar(256) NOT NULL,
		FieldValue    nvarchar(256) NULL,
		OldFieldValue nvarchar(256) NULL,
		Source        nvarchar(max) NULL,
		Comment       nvarchar(max) NULL,
		modifiedBy    int NOT NULL,
		modified      datetime NOT NULL
	)
END
GO

